# -*- encoding=utf-8 -*-
from PyQt5.QtCore import *
from comPort import *
import re
import openpyxl
import datetime
import struct


defaultTemperature = 25

class Thread_McuComToolHandle(QThread):
    signalComPort = pyqtSignal(str) #Com port name
    signalComData = pyqtSignal(list) #Com data list
    signalComLog  = pyqtSignal(str) #Com port status

    def __init__(self):
        super(Thread_McuComToolHandle, self).__init__()
        self.excelInit()
        self.comPort = COM()
        self.lastListPort = "None"
        self.comName = "None"
        self.baudRate = 115200
        self.batMcuData = []  #Use to send data to MCU
        self.portDataTxRxEnableFlag = 0 #Use to tell the thread, data is transmitting
        self.portOpenFlag = 0 #Use to tell the thread open port

    def run(self):
        while True:
            # Refresh the port information when new COM port insert
            listPort = self.comPort.list_port()  # list port names on port selection
            if  self.lastListPort != listPort:
                self.signalComPort.emit("None")#clear the list and then update
                if listPort != "None":  # Port can be find
                    for item in list(listPort):
                        self.signalComPort.emit(item[1])
                if self.lastListPort != listPort:
                    self.lastListPort = listPort

            # When the Use click the open com port button
            if self.portOpenFlag == 1:
            # if self.comName!= "None" and self.portOpenFlag == 1:
                try:
                    self.excelInit()
                    self.comPort.open_port(self.comName, self.baudRate)
                    self.signalComLog.emit("Port " + self.comName+" open success!")
                except:
                    self.signalComLog.emit("Port is occuped!")#User reopen the COM Port in other software
                    self.portDataTxRxEnableFlag = 0  #disable data receiving
                self.portOpenFlag = 0#Wait for next click on COM port open button

            #Save data from MCU into excel
            if self.portDataTxRxEnableFlag == 1:
                if self.mcuDataTxFlag == 1:
                    self.signalComLog.emit("Start transmition!")  # The device is removed from PC
                    self.mcuDataTransmition()
                # dataList = self.receiveBytes(64)
                # self.signalComData.emit(dataList) #Send the data to display
                # self.sheet["A"+ str(self.lineCount)] = self.lineCount-2 #Add time stamp
                # columnCount = 1
                # for item in dataList:
                #     self.sheet[self.excelNumName[columnCount] + str(self.lineCount)] = item
                #     columnCount += 1
                # self.lineCount += 1
                try:
                    dataList = self.receiveBytes(64)
                    self.signalComData.emit(dataList) #Send the data to display
                    self.sheet["A"+ str(self.lineCount)] = self.lineCount-2 #Add time stamp
                    columnCount = 1
                    for item in dataList:
                        self.sheet[self.excelNumName[columnCount] + str(self.lineCount)] = item
                        columnCount += 1
                    self.lineCount += 1
                except:
                    if self.portDataTxRxEnableFlag!=0:
                        self.signalComLog.emit("Port may be removed or occupied")#The device is removed from PC
                        self.portDataTxRxEnableFlag = 0 #Finish receiving data


    def openComPort(self, comName):
        # If there is port connection, close it first
        if self.portDataTxRxEnableFlag == 1:
            self.portDataTxRxEnableFlag = 0 #Tell the while loop the port is closed
            self.comPort.close_port()  # Termate the Port communication to avoid blocked at the data receiving
        comNumRegex = re.compile(r'COM\d\d\d|COM\d\d|COM\d')
        self.comName = comNumRegex.search(comName).group()
        self.portOpenFlag = 1
        self.portDataTxRxEnableFlag = 1
        self.mcuDataTxFlag = 0 #Disable MCUData transmit to MCU
        pass

    def closeComPort(self):#Make sure the main thread will not conflit between the slave thread
        self.portDataTxRxEnableFlag = 0#Tell the while loop, the COM port is closed
        self.mcuDataTxFlag = 0 #Disable MCUData transmit to MCU
        if self.comName != "None":
            self.comPort.close_port()#Termate the Port communication to avoid blocked at the data receiving
            self.signalComData.emit([])  # clear the display
            self.signalComLog.emit("Connection terminated and data saved!")  # The device is removed from PC
            self.comName = "None"
            if self.sheet["A2"].value != None:  # check whether there is any data saved
                self.wb.save(self.sheetTitle + '.xlsx')
            self.excelInit()

    def excelInit(self):
        # init excel
        self.wb = openpyxl.Workbook()
        self.sheet = self.wb["Sheet"]
        self.sheet["A1"] = "TimeStamp"
        self.sheet["B1"] = "Counter"
        self.sheet["C1"] = "VCELL(mV)"
        self.sheet["D1"] = "ICELL(mA)"
        self.sheet["E1"] = "AvgVCELL(mV)"
        self.sheet["F1"] = "AvgICELL(mA)"
        self.sheet["G1"] = "TCELL(C)"
        self.sheet["H1"] = "NomSOC(%)"
        self.sheet["I1"] = "CusSOC(%)"
        self.sheet["J1"] = "SmoothSOC(%)"
        self.sheet["K1"] = "SOH(%)"
        self.sheet["L1"] = "NomFuCap(mAh)"
        self.sheet["M1"] = "CusFuCap(mAh)"
        self.sheet["N1"] = "NomRemCap(mAh)"
        self.sheet["O1"] = "CusRemCap(mAh)"
        self.sheet["P1"] = "RawNomFuCap(mAh)"
        self.sheet["Q1"] = "CaliOCV(mV)"
        self.sheet["R1"] = "AbsEmptySOC(%)"
        self.sheet["S1"] = "AbsFullSOC(%)"
        self.sheet["T1"] = "EmptyMatrixCount"
        self.sheet["U1"] = "FullMatrixCount"
        self.sheet["V1"] = "DeltaCap(mAh)"
        self.sheet["W1"] = "DeltaSOC(%)"
        self.sheet["X1"] = "CaliSOC(%)"
        self.sheet["Y1"] = "DHGCycles"
        self.sheet["Z1"] = "WarnFlags"
        self.sheet["AA1"] = "SysState"
        self.sheet["AB1"] = "BattState"
        self.sheet["AC1"] = "CusData1"
        self.sheet["AD1"] = "CusData2"
        self.sheet["AE1"] = "CusData3"
        self.sheet["AF1"] = "CusData4"
        self.sheet["AG1"] = "CusData5"


        self.sheetTitle = datetime.datetime.now().strftime('%Y-%m-%d-%H-%M') + "-McuData"
        self.excelNumName = ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q",
                             "R", "S", "T","U", "V", "W", "X","Y","Z","AA", "AB", "AC", "AD", "AE", "AF", "AG"]
        self.lineCount = 2


    def receiveBytes(self, num):
        self.receiveData = []

        while True:
            if self.comPort.ser.in_waiting:
                str = self.comPort.ser.read(2)
                # Combine 2 bytes into one data
                if str == '':
                    pass
                if (int(str[0]) < 128):
                    sendValue = 256 * int(str[0]) + int(str[1])
                else:  # Negative value
                    sendValue = -(65535 - (256 * int(str[0]) + int(str[1]) - 1))  # 原码

                #One frame is received
                if sendValue == 23130 and len(self.receiveData) != 0:  # 0x5A5A
                    # remove first head data

                    if (len(self.receiveData) < int(num / 2)):  # The buffer is not full
                        for i in range(int(num / 2) - len(self.receiveData)):
                            self.receiveData.append(0)

                    for i in range(6, 10):  # For the percentage result need to divide 10 to ensure its resolution
                        self.receiveData[i] = self.receiveData[i] / 10
                    for i in range(16, 18):  # For the percentage result need to divide 10 to ensure its resolution
                        self.receiveData[i] = self.receiveData[i] / 10
                    for i in range(21, 23):  # For the percentage result need to divide 10 to ensure its resolution
                        self.receiveData[i] = self.receiveData[i] / 10

                    return self.receiveData
                else:
                    self.receiveData.append(sendValue)

    def startTransmitMcuData(self,fileName):
        self.mcuDataTxFlag = 1 #enable data transimit to MCU
        self.batMcuData = []  # init batMcuData table
        if self.portDataTxRxEnableFlag == 1:
            self.signalComLog.emit("Load McuData runfile!")  # The device is removed from PC
            try:
                self.fileName = fileName
                self.excelFile = openpyxl.load_workbook(fileName)
                self.excelSheet = self.excelFile.get_sheet_by_name("Sheet")
                rows = self.excelSheet.max_row
                for i in range(2, rows + 1):
                    self.batMcuData.append({"Vcell": self.excelSheet.cell(row=i, column=3).value,
                                            "Icell": self.excelSheet.cell(row=i, column=4).value,
                                            "Tcell": self.excelSheet.cell(row=i, column=7).value})
                pass
            except:
                self.signalComLog.emit("Load McuData runfile failed!")  # The device is removed from PC
                self.mcuDataTxFlag = 0


            self.openComPort(self.comName)#Disable 64 byte receving
            self.mcuDataTxFlag = 1  # enable data transimit to MCU
        else:
            self.signalComLog.emit("Please open port first!")  # The device is removed from PC

    def mcuDataTransmition(self):
        if len(self.batMcuData) != 0:
            runTimeData =  self.batMcuData.pop(0)

            self.comPort.ser.write(chr(0x5a).encode('utf-8'))
            self.comPort.ser.write(chr(0x5a).encode('utf-8'))
            self.comPort.ser.write(struct.pack('h', runTimeData.get("Vcell")))
            self.comPort.ser.write(struct.pack('h', runTimeData.get("Icell")))
            self.comPort.ser.write(struct.pack('b', runTimeData.get("Tcell")))
        else:
            self.closeComPort() #close the communication, when the MCUData transmition is finished





